﻿Imports System.IO

Public Class WebFavorite
    Implements IDisposable


    Private disposedValue As Boolean = False        ' To detect redundant calls

    ' IDisposable
    Protected Overridable Sub Dispose(ByVal disposing As Boolean)
        If Not Me.disposedValue Then
            If disposing Then
                ' TODO: free other state (managed objects).
            End If

            ' TODO: free your own state (unmanaged objects).
            ' TODO: set large fields to null.
        End If
        Me.disposedValue = True
    End Sub

#Region " IDisposable Support "
    ' This code added by Visual Basic to correctly implement the disposable pattern.
    Public Sub Dispose() Implements IDisposable.Dispose
        ' Do not change this code.  Put cleanup code in Dispose(ByVal disposing As Boolean) above.
        Dispose(True)
        GC.SuppressFinalize(Me)
    End Sub
#End Region

    'Składowe publiczne.
    Public Name As String
    Public Url As String

    Public Sub Load(ByVal fileName As String)
        'Deklaracja zmiennych.
        Dim strData As String
        Dim strLines() As String
        Dim strLine As String
        Dim objFileInfo As New FileInfo(fileName)

        'Przypisywanie nazwy pliku bez rozszerzenia do składowej Name.
        Name = objFileInfo.Name.Substring(0, _
            objFileInfo.Name.Length - objFileInfo.Extension.Length)

        Try
            'Wczytanie całej zawartości pliku.
            strData = My.Computer.FileSystem.ReadAllText(fileName)

            'Rozbijanie danych z pliku na wiersze.
            strLines = strData.Split(New String() {ControlChars.CrLf}, _
                StringSplitOptions.RemoveEmptyEntries)

            'Przetwarzanie każdego wiersza w poszukiwaniu adresu URL.
            For Each strLine In strLines
                'Czy wiersz rozpoczyna się od URL=?
                If strLine.StartsWith("URL=") Then
                    'Jeśli tak, przypisywanie adresu URL do składowej Url.
                    Url = strLine.Substring(4)
                    'Wyjście z pętli For … Next.
                    Exit For
                End If
            Next
        Catch IOExceptionErr As IOException
            'Zwrócenie wyjątku do jednostki wywołującej.
            Throw New Exception(IOExceptionErr.Message)
        End Try
    End Sub

End Class
